/* eslint-disable */

/**
 * Generated by Verge3D Puzzles v.4.10.0
 * Fri, 22 Aug 2025 05:47:40 GMT
 * Prefer not editing this file as your changes may get overridden once Puzzles are saved.
 * Check out https://www.soft8soft.com/docs/manual/en/introduction/Using-JavaScript.html
 * for the information on how to add your own JavaScript to Verge3D apps.
 */
function createPL(v3d = window.v3d) {

// global variables used in the init tab
const _initGlob = {
    percentage: 0,
    output: {
        initOptions: {
            fadeAnnotations: true,
            useBkgTransp: false,
            preserveDrawBuf: false,
            useCompAssets: false,
            useFullscreen: true,
            useCustomPreloader: false,
            preloaderStartCb: function() {},
            preloaderProgressCb: function() {},
            preloaderEndCb: function() {},
        },
    },
};


// global variables/constants used by puzzles' functions
var _pGlob = {};

_pGlob.objCache = new Map();
_pGlob.fadeAnnotations = true;
_pGlob.pickedObject = '';
_pGlob.hoveredObject = '';
_pGlob.mediaElements = {};
_pGlob.loadedFile = '';
_pGlob.states = [];
_pGlob.percentage = 0;
_pGlob.openedFile = '';
_pGlob.openedFileMeta = {};
_pGlob.xrSessionAcquired = false;
_pGlob.xrSessionCallbacks = [];
_pGlob.screenCoords = new v3d.Vector2();
_pGlob.intervalTimers = {};
_pGlob.customEvents = new v3d.EventDispatcher();
_pGlob.eventListeners = [];
_pGlob.htmlElements = new Set();
_pGlob.materialsCache = new Map();

_pGlob.AXIS_X = new v3d.Vector3(1, 0, 0);
_pGlob.AXIS_Y = new v3d.Vector3(0, 1, 0);
_pGlob.AXIS_Z = new v3d.Vector3(0, 0, 1);
_pGlob.MIN_DRAG_SCALE = 10e-4;
_pGlob.SET_OBJ_ROT_EPS = 1e-8;

_pGlob.vec2Tmp = new v3d.Vector2();
_pGlob.vec2Tmp2 = new v3d.Vector2();
_pGlob.vec3Tmp = new v3d.Vector3();
_pGlob.vec3Tmp2 = new v3d.Vector3();
_pGlob.vec3Tmp3 = new v3d.Vector3();
_pGlob.vec3Tmp4 = new v3d.Vector3();
_pGlob.eulerTmp = new v3d.Euler();
_pGlob.eulerTmp2 = new v3d.Euler();
_pGlob.quatTmp = new v3d.Quaternion();
_pGlob.quatTmp2 = new v3d.Quaternion();
_pGlob.colorTmp = new v3d.Color();
_pGlob.mat4Tmp = new v3d.Matrix4();
_pGlob.planeTmp = new v3d.Plane();
_pGlob.raycasterTmp = new v3d.Raycaster(); // always check visibility

const createPzLib = ({ v3d=null, appInstance=null }) => {
    function getElement(id, isParent=false) {
        let elem;
        if (Array.isArray(id) && id[0] === 'CONTAINER') {
            if (appInstance !== null) {
                elem = appInstance.container;
            } else if (typeof _initGlob !== 'undefined') {
                // if we are on the initialization stage, we still can have access
                // to the container element
                const contId = _initGlob.container;
                elem = isParent ? parent.document.getElementById(contId)
                        : document.getElementById(contId);
            }
        } else if (Array.isArray(id) && id[0] === 'WINDOW') {
            elem = isParent ? parent : window;
        } else if (Array.isArray(id) && id[0] === 'DOCUMENT') {
            elem = isParent ? parent.document : document;
        } else if (Array.isArray(id) && id[0] === 'BODY') {
            elem = isParent ? parent.document.body : document.body;
        } else if (Array.isArray(id) && id[0] === 'QUERYSELECTOR') {
            elem = isParent ? parent.document.querySelector(id)
                    : document.querySelector(id);
        } else {
            elem = isParent ? parent.document.getElementById(id)
                    : document.getElementById(id);
        }
        return elem;
    }
        
    function getElements(ids, isParent=false) {
        const elems = [];
        if (Array.isArray(ids) && ids[0] !== 'CONTAINER' && ids[0] !== 'WINDOW'
                && ids[0] !== 'DOCUMENT' && ids[0] !== 'BODY'
                && ids[0] !== 'QUERYSELECTOR') {
            for (let i = 0; i < ids.length; i++) {
                elems.push(getElement(ids[i], isParent));
            }
        } else {
            elems.push(getElement(ids, isParent));
        }
        return elems;
    }
        
    function transformCoordsSpace(coords, spaceFrom, spaceTo, noSignChange=false) {
    
        if (spaceFrom === spaceTo) {
            return coords;
        }
    
        const y = coords.y;
        const z = coords.z;
    
        if (spaceFrom === 'Z_UP_RIGHT' && spaceTo === 'Y_UP_RIGHT') {
            coords.y = z;
            coords.z = noSignChange ? y : -y;
        } else if (spaceFrom === 'Y_UP_RIGHT' && spaceTo === 'Z_UP_RIGHT') {
            coords.y = noSignChange ? z : -z;
            coords.z = y;
        } else {
            console.error('transformCoordsSpace: Unsupported coordinate space');
        }
    
        return coords;
    }
        
    const transformEulerV3dToBlenderShortest = function() {
        const eulerTmp = new v3d.Euler();
        const eulerTmp2 = new v3d.Euler();
        const vec3Tmp = new v3d.Vector3();
    
        return function(euler, dest) {
            const eulerBlender = eulerTmp.copy(euler).reorder('YZX');
            const eulerBlenderAlt = eulerTmp2.copy(eulerBlender).makeAlternative();
    
            const len = vec3Tmp.setFromEuler(eulerBlender).lengthSq();
            const lenAlt = vec3Tmp.setFromEuler(eulerBlenderAlt).lengthSq();
    
            dest.copy(len < lenAlt ? eulerBlender : eulerBlenderAlt);
            return transformCoordsSpace(dest, 'Y_UP_RIGHT', 'Z_UP_RIGHT');
        }
    }();
        
    function getSceneCoordSystem() {
        const scene = appInstance.scene;
        if (scene && 'coordSystem' in scene.userData) {
            return scene.userData.coordSystem;
        }
    
        return 'Y_UP_RIGHT';
    }
        
    function isObjectWorthProcessing(obj) {
        return obj.name !== '' &&
                !(obj.isMesh && obj.isMaterialGeneratedMesh) &&
                !obj.isAuxClippingMesh;
    }
        
    function getObjectByName(objName) {
        let objFound = null;
    
        // COMPAT: <4.9.0, old engine, new puzzles
        const isID = v3d.MathUtils.checkUUID ? v3d.MathUtils.checkUUID(objName) : false;
    
        const pGlobAvailable = _pGlob !== undefined;
        if (pGlobAvailable)
            objFound = _pGlob.objCache.get(objName);
    
        if (objFound && (isID ? objFound.uuid === objName : objFound.name === objName))
            return objFound;
    
        function findValidByName(obj, objName) {
            if ((isID ? obj.uuid === objName : obj.name === objName) && isObjectWorthProcessing(obj))
                return obj;
    
            for (let i = 0; i < obj.children.length; i++) {
                const child = obj.children[i];
                const object = findValidByName(child, objName);
                if (object !== null)
                    return object;
            }
    
            return null;
        }
    
        if (appInstance.scene) {
            objFound = findValidByName(appInstance.scene, objName);
            if (objFound && pGlobAvailable)
                _pGlob.objCache.set(objName, objFound);
        }
    
        return objFound;
    }
        
    function getObjectNamesByGroupName(groupName) {
        const objNameList = [];
        appInstance.scene.traverse(obj => {
            if (isObjectWorthProcessing(obj)) {
                const objGroupNames = obj.groupNames;
                if (!objGroupNames) {
                    return;
                }
    
                for (let i = 0; i < objGroupNames.length; i++) {
                    const objGroupName = objGroupNames[i];
                    if (objGroupName === groupName) {
                        objNameList.push(obj.name);
                    }
                }
            }
        });
        return objNameList;
    }
        
    function getAllObjectNames() {
        const objNameList = [];
        appInstance.scene.traverse(obj => {
            if (isObjectWorthProcessing(obj)) {
                objNameList.push(obj.name);
            }
        });
        return objNameList;
    }
        
    function retrieveObjectNamesAccum(currObjNames, namesAccum) {
        if (typeof currObjNames === 'string') {
            namesAccum.push(currObjNames);
        } else if (Array.isArray(currObjNames) && currObjNames[0] === 'GROUP') {
            const newObjNames = getObjectNamesByGroupName(currObjNames[1]);
            for (let i = 0; i < newObjNames.length; i++) {
                namesAccum.push(newObjNames[i]);
            }
        } else if (Array.isArray(currObjNames) && currObjNames[0] === 'ALL_OBJECTS') {
            const newObjNames = getAllObjectNames();
            for (let i = 0; i < newObjNames.length; i++) {
                namesAccum.push(newObjNames[i]);
            }
        } else if (Array.isArray(currObjNames)) {
            for (let i = 0; i < currObjNames.length; i++) {
                retrieveObjectNamesAccum(currObjNames[i], namesAccum);
            }
        }
    }
        
    function retrieveObjectNames(objNames) {
        const accum = [];
        retrieveObjectNamesAccum(objNames, accum);
        return accum.filter(name => name !== '');
    }
        
    function RotationInterface() {
        /**
         * @ignore
         * For user manipulations use XYZ extrinsic rotations (which
         * are the same as ZYX intrinsic rotations)
         *     - Blender/Max/Maya use extrinsic rotations in the UI
         *     - XYZ is the default option, but could be set from
         *       some order hint if exported
         */
        this._userRotation = new v3d.Euler(0, 0, 0, 'ZYX');
        this._actualRotation = new v3d.Euler();
    }
    
    Object.assign(RotationInterface, {
        initObject: function(obj) {
            if (obj.userData.puzzles === undefined) {
                obj.userData.puzzles = {}
            }
            if (obj.userData.puzzles.rotationInterface === undefined) {
                obj.userData.puzzles.rotationInterface = new RotationInterface();
            }
    
            const rotUI = obj.userData.puzzles.rotationInterface;
            rotUI.updateFromObject(obj);
            return rotUI;
        },
    });
    
    Object.assign(RotationInterface.prototype, {
        updateFromObject: function(obj) {
            const SYNC_ROT_EPS = 1e-8;
    
            if (!this._actualRotation.equalsEps(obj.rotation, SYNC_ROT_EPS)) {
                this._actualRotation.copy(obj.rotation);
                this._updateUserRotFromActualRot();
            }
        },
    
        getActualRotation: function(euler) {
            return euler.copy(this._actualRotation);
        },
    
        setUserRotation: function(euler) {
            // don't copy the order, since it's fixed to ZYX for now
            this._userRotation.set(euler.x, euler.y, euler.z);
            this._updateActualRotFromUserRot();
        },
    
        getUserRotation: function(euler) {
            return euler.copy(this._userRotation);
        },
    
        _updateUserRotFromActualRot: function() {
            const order = this._userRotation.order;
            this._userRotation.copy(this._actualRotation).reorder(order);
        },
    
        _updateActualRotFromUserRot: function() {
            const order = this._actualRotation.order;
            this._actualRotation.copy(this._userRotation).reorder(order);
        },
    });
        
    function getObjectName(obj) {
        // auto-generated from a multi-material object, use parent name instead
        if (obj.isMesh && obj.isMaterialGeneratedMesh && obj.parent) {
            return obj.parent.name;
        } else {
            return obj.name;
        }
    }
        
    function areListenersSame(target0, type0, listener0, optionsOrUseCapture0,
            target1, type1, listener1, optionsOrUseCapture1) {
        const capture0 = Boolean(optionsOrUseCapture0 instanceof Object
                ? optionsOrUseCapture0.capture : optionsOrUseCapture0);
        const capture1 = Boolean(optionsOrUseCapture1 instanceof Object
                ? optionsOrUseCapture1.capture : optionsOrUseCapture1);
        return target0 === target1 && type0 === type1 && listener0 === listener1
                && capture0 === capture1;
    }
        
    function bindListener(target, type, listener, optionsOrUseCapture) {
        const alreadyExists = _pGlob.eventListeners.some(elem => {
            return areListenersSame(elem.target, elem.type, elem.listener,
                    elem.optionsOrUseCapture, target, type, listener,
                    optionsOrUseCapture);
        });
    
        if (!alreadyExists) {
            target.addEventListener(type, listener, optionsOrUseCapture);
            _pGlob.eventListeners.push({ target, type, listener,
                    optionsOrUseCapture });
        }
    }
        
    function initObjectPicking(callback, eventType, mouseDownUseTouchStart=false,
            allowedMouseButtons=null) {
    
        // css renderer prevents interacting with canvas, in that case we assign events on container
        const elem = appInstance.cssRenderer ? appInstance.container : appInstance.renderer.domElement;
        bindListener(elem, eventType, pickListener);
    
        if (eventType === 'mousedown') {
    
            const touchEventName = mouseDownUseTouchStart ? 'touchstart' : 'touchend';
            bindListener(elem, touchEventName, pickListener);
    
        } else if (eventType === 'dblclick') {
    
            let prevTapTime = 0;
    
            function doubleTapCallback(event) {
                const now = new Date().getTime();
                const timesince = now - prevTapTime;
    
                if (timesince < 600 && timesince > 0) {
                    pickListener(event);
                    prevTapTime = 0;
                    return;
                }
    
                prevTapTime = new Date().getTime();
            }
    
            const touchEventName = mouseDownUseTouchStart ? 'touchstart' : 'touchend';
            bindListener(elem, touchEventName, doubleTapCallback);
        }
    
        const raycaster = new v3d.Raycaster();
    
        function pickListener(event) {
    
            // to handle unload in loadScene puzzle
            if (!appInstance.getCamera()) {
                return;
            }
    
            event.preventDefault();
    
            let xNorm = 0;
            let yNorm = 0;
            if (event instanceof MouseEvent) {
                if (allowedMouseButtons !== null && allowedMouseButtons.indexOf(event.button) === -1) {
                    return;
                }
                xNorm = event.offsetX / elem.clientWidth;
                yNorm = event.offsetY / elem.clientHeight;
            } else if (event instanceof TouchEvent) {
                const rect = elem.getBoundingClientRect();
                xNorm = (event.changedTouches[0].clientX - rect.left) / rect.width;
                yNorm = (event.changedTouches[0].clientY - rect.top) / rect.height;
            }
    
            _pGlob.screenCoords.x = xNorm * 2 - 1;
            _pGlob.screenCoords.y = -yNorm * 2 + 1;
            raycaster.setFromCamera(_pGlob.screenCoords, appInstance.getCamera(true));
    
            const objList = [];
            appInstance.scene.traverse(obj => objList.push(obj));
    
            const intersects = raycaster.intersectObjects(objList, false);
            callback(intersects, event);
        }
    }
        
    function isObjectAmongObjects(objNameToCheck, objUUIDToCheck, objNames) {
        if (!objNameToCheck) {
            return false;
        }
    
        // COMPAT: <4.10, when calling with 2 arguments
        if (Array.isArray(objUUIDToCheck)) {
            objNames = objUUIDToCheck;
            objUUIDToCheck = objNameToCheck;
        }
    
        for (let i = 0; i < objNames.length; i++) {
            const objName = objNames[i];
    
            // COMPAT: < 4.10 (4.9), old engine, new puzzles
            const isID = v3d.MathUtils.checkUUID ? v3d.MathUtils.checkUUID(objName) : false;
    
            if ((isID ? objUUIDToCheck : objNameToCheck) === objName) {
                return true;
            } else {
                // also check children which are auto-generated for multi-material objects
                const obj = getObjectByName(objName);
                if (obj && obj.type === 'Group') {
                    for (let j = 0; j < obj.children.length; j++) {
                        // if parent referred by UUID, compare children also by UUID
                        if (isID ? (objUUIDToCheck === obj.children[j].uuid) : (objNameToCheck === obj.children[j].name)) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }
        
    function getMaterialEditableTextures(matName, collectSameNameMats=false) {
        let mats = [];
        if (collectSameNameMats) {
            mats = v3d.SceneUtils.getMaterialsByName(appInstance, matName);
        } else {
            const firstMat = v3d.SceneUtils.getMaterialByName(appInstance, matName);
            if (firstMat !== null) {
                mats = [firstMat];
            }
        }
    
        const textures = mats.reduce((texArray, mat) => {
            let matTextures = [];
            switch (mat.type) {
                case 'MeshNodeMaterial':
                    matTextures = Object.values(mat.nodeTextures);
                    break;
    
                case 'MeshStandardMaterial':
                    matTextures = [
                        mat.map, mat.lightMap, mat.aoMap, mat.emissiveMap,
                        mat.bumpMap, mat.normalMap, mat.displacementMap,
                        mat.roughnessMap, mat.metalnessMap, mat.alphaMap, mat.envMap
                    ];
                    break;
    
                default:
                    console.error('getMaterialEditableTextures: Unknown material type '
                            + mat.type);
                    break;
            }
    
            Array.prototype.push.apply(texArray, matTextures);
            return texArray;
        }, []);
    
        return textures.filter(elem => {
            // check Texture type exactly
            return elem && (elem.constructor === v3d.Texture
                    || elem.constructor === v3d.CompressedTexture
                    || elem.constructor === v3d.DataTexture
                    || elem.constructor === v3d.CanvasTexture
                    || elem.constructor === v3d.VideoTexture);
        });
    }
        
    function replaceMaterialEditableTexture(mat, oldTex, newTex) {
        if (v3d.MaterialUtils.replaceTexture) {
            v3d.MaterialUtils.replaceTexture(mat, oldTex, newTex);
            return;
        }
    
        // COMPAT: <4.8, had no replaceTexture() method
        switch (mat.type) {
            case 'MeshNodeMaterial':
                // NOTE: replace in node graph as well since it's possible to texture get lost
                // after updateNodeGraph()
                mat.traverseNodes(node => {
                    if (node.originData.texture === oldTex)
                        node.originData.texture = newTex;
                });
    
                for (const name in mat.nodeTextures) {
                    if (mat.nodeTextures[name] === oldTex) {
                        mat.nodeTextures[name] = newTex;
                    }
                }
                break;
    
            case 'MeshStandardMaterial':
                const texNames = ['map', 'lightMap', 'aoMap', 'emissiveMap',
                        'bumpMap', 'normalMap', 'displacementMap', 'roughnessMap',
                        'metalnessMap', 'alphaMap', 'envMap'];
    
                texNames.forEach(name => {
                    if (mat[name] === oldTex) {
                        mat[name] = newTex;
                    }
                });
                break;
    
            default:
                console.error('replaceMaterialEditableTexture: Unsupported material type '
                        + mat.type);
                break;
        }
    
        // inherit some save params
        newTex.encoding = oldTex.encoding;
        newTex.wrapS = oldTex.wrapS;
        newTex.wrapT = oldTex.wrapT;
    }
        
    function getMaterialEditableValues(matName) {
        const mat = v3d.SceneUtils.getMaterialByName(appInstance, matName);
        if (!mat) {
            return [];
        }
    
        if (mat.isMeshNodeMaterial) {
            return Object.keys(mat.nodeValueMap);
        } else if (mat.isMeshStandardMaterial) {
            return ['metalness', 'roughness', 'bumpScale', 'emissiveIntensity',
                    'envMapIntensity'];
        } else {
            return [];
        }
    }
        
    const CanvasTxt = function(t){var e={};function n(r){if(e[r])return e[r].exports;var i=e[r]={i:r,l:!1,exports:{}};return t[r].call(i.exports,i,i.exports,n),i.l=!0,i.exports}return n.m=t,n.c=e,n.d=function(t,e,r){n.o(t,e)||Object.defineProperty(t,e,{enumerable:!0,get:r})},n.r=function(t){"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(t,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(t,"__esModule",{value:!0})},n.t=function(t,e){if(1&e&&(t=n(t)),8&e)return t;if(4&e&&"object"==typeof t&&t&&t.__esModule)return t;var r=Object.create(null);if(n.r(r),Object.defineProperty(r,"default",{enumerable:!0,value:t}),2&e&&"string"!=typeof t)for(var i in t)n.d(r,i,function(e){return t[e]}.bind(null,i));return r},n.n=function(t){var e=t&&t.__esModule?function(){return t.default}:function(){return t};return n.d(e,"a",e),e},n.o=function(t,e){return Object.prototype.hasOwnProperty.call(t,e)},n.p="",n(n.s=0)}([function(t,e,n){"use strict";function r(t,e){return function(t){if(Array.isArray(t))return t}(t)||function(t,e){var n=[],r=!0,i=!1,o=void 0;try{for(var u,a=t[Symbol.iterator]();!(r=(u=a.next()).done)&&(n.push(u.value),!e||n.length!==e);r=!0);}catch(t){i=!0,o=t}finally{try{r||null==a.return||a.return()}finally{if(i)throw o}}return n}(t,e)||function(){throw new TypeError("Invalid attempt to destructure non-iterable instance")}()}n.r(e);var i={debug:!1,align:"center",vAlign:"middle",fontSize:14,fontWeight:"",fontStyle:"",fontVariant:"",font:"Arial",lineHeight:null,justify:!1,drawText:function(t,e,n,i,o,u){var a=this,s=r([n,i,o,u].map(function(t){return parseInt(t)}),4);if(n=s[0],i=s[1],o=s[2],u=s[3],!(0>=o||0>=u||0>=this.fontSize)){var f=n+o,l=i+u;this.textSize&&console.error("%cCanvas-Txt:","font-weight: bold;","textSize is depricated and has been renamed to fontSize");var c=this.fontStyle,h=this.fontVariant,d=this.fontWeight,g=this.fontSize,v=this.font,p="".concat(c," ").concat(h," ").concat(d," ").concat(g,"px ").concat(v);t.font=p;var b,y=i+u/2+parseInt(this.fontSize)/2;"right"===this.align?(b=f,t.textAlign="right"):"left"===this.align?(b=n,t.textAlign="left"):(b=n+o/2,t.textAlign="center");var x=[],m=e.split("\n"),T=this.justify?t.measureText(" ").width:0;m.forEach(function(e){var n=t.measureText(e).width;if(n<=o)x.push(e);else{var r,i,u,s=e,f=o;for(n=t.measureText(s).width;n>f;){for(r=0,i=0,u="";i<f;)r++,u=s.substr(0,r),i=t.measureText(s.substr(0,r)).width;r--,u=u.substr(0,r);var l=r;if(" "!=s.substr(r,1)){for(;" "!=s.substr(r,1)&&0!=r;)r--;0==r&&(r=l),u=s.substr(0,r)}u=a.justify?a.justifyLine(t,u,T," ",o):u,s=s.substr(r),n=t.measureText(s).width,x.push(u)}0<n&&x.push(s)}});var S=this.lineHeight?this.lineHeight:this.getTextHeight(t,e,p),w=S*(x.length-1),j=i;return"top"===this.vAlign?y=i+this.fontSize:"bottom"===this.vAlign?(y=l-w,j=l):(j=i+u/2,y-=w/2),x.forEach(function(e){e=e.trim(),t.fillText(e,b,y),y+=S}),this.debug&&(t.lineWidth=3,t.strokeStyle="#00909e",t.strokeRect(n,i,o,u),t.lineWidth=2,t.strokeStyle="#f6d743",t.beginPath(),t.moveTo(b,i),t.lineTo(b,l),t.stroke(),t.strokeStyle="#ff6363",t.beginPath(),t.moveTo(n,j),t.lineTo(f,j),t.stroke()),{height:w+S}}},getTextHeight:function(t,e,n){var r=t.textBaseline,i=t.font;t.textBaseline="bottom",t.font=n;var o=t.measureText(e).actualBoundingBoxAscent;return t.textBaseline=r,t.font=i,o},justifyLine:function(t,e,n,r,i){var o=Math.floor,u=e.trim(),a=t.measureText(u).width,s=u.split(/\s+/).length-1,f=o((i-a)/n);if(0>=s||0>=f)return u;for(var l=o(f/s),c=f-s*l,h=[],d=0;d<l;d++)h.push(r);return h=h.join(""),u.replace(/\s+/g,function(t){var e=0<c?h+r:h;return c--,t+e})}};e.default=i}]).default;
        
    class MediaHTML5 {
        constructor() {
            this.source = null;
        }
    
        load(url, isVideo) {
            if (isVideo) {
                this.source = document.createElement('video');
                this.source.playsInline = true;
                this.source.preload = 'auto';
                this.source.autoload = true;
                this.source.crossOrigin = 'anonymous';
            } else {
                this.source = document.createElement('audio');
            }
    
            this.source.src = url;
            return this;
        }
    
        play() {
            this.source.play();
        }
    
        pause() {
            this.source.pause();
        }
    
        stop() {
            this.source.pause();
            this.source.currentTime = 0;
        }
    
        rewind() {
            this.source.currentTime = 0;
        }
    
        setPlaybackTime(time) {
            this.source.currentTime = time
        }
    
        getPlaybackTime() {
            return this.source.currentTime;
        }
    
        getDuration() {
            return this.source.duration;
        }
    
        setPlaybackRate(rate) {
            this.source.playbackRate = rate;
        }
    
        isPlaying() {
            return this.source.duration > 0 && !this.source.paused;
        }
    
        setLoop(looped) {
            this.source.loop = looped;
        }
    
        setVolume(volume) {
            this.source.volume = volume;
        }
    
        setMuted(muted) {
            this.source.muted = muted;
        }
    
        toPositional() {
            if (!(this.audio instanceof v3d.PositionalAudio)) {
                const posAudio = new v3d.PositionalAudio(new v3d.AudioListener());
                posAudio.setMediaElementSource(this.source);
                this.audio = posAudio;
            }
            return this.audio;
        }
    }
        
    function getObjectUUID(obj) {
        // auto-generated from a multi-material object, use parent UUID instead
        if (obj.isMesh && obj.isMaterialGeneratedMesh && obj.parent) {
            return obj.parent.uuid;
        } else {
            return obj.uuid;
        }
    }
        
    function xrTraverseNonControllers(obj, callback) {
        if (obj.name.startsWith('XR_CONTROLLER_')) {
            return;
        }
    
        callback(obj);
    
        const children = obj.children;
        for (let i = 0, l = children.length; i < l; i++) {
            xrTraverseNonControllers(children[i], callback);
        }
    };
        
    function xrGetIntersections(controller) {
        controller.updateWorldMatrix(true, false);
    
        _pGlob.mat4Tmp.identity().extractRotation(controller.matrixWorld);
    
        const objList = [];
        xrTraverseNonControllers(appInstance.scene, obj => objList.push(obj));
    
        const raycaster = new v3d.Raycaster();
        raycaster.ray.origin.setFromMatrixPosition(controller.matrixWorld);
        raycaster.ray.direction.set(0, 0, -1).applyMatrix4(_pGlob.mat4Tmp);
    
        return raycaster.intersectObjects(objList, false);
    }
        
    function xrOnSelect(event) {
        if (!_pGlob.objClickInfo) {
            return;
        }
    
        const controller = event.target;
        const intersections = xrGetIntersections(controller);
    
        if (intersections.length > 0) {
            const intersection = intersections[0];
            const obj = intersection.object;
    
            _pGlob.objClickInfo.forEach(info => {
                const objName = getObjectName(obj);
                const objUUID = getObjectUUID(obj);
    
                // save the object for the pickedObject block
                _pGlob.pickedObject = info.useID ? objUUID : objName;
    
                const isPicked = obj && isObjectAmongObjects(objName, objUUID,
                        retrieveObjectNames(info.objSelector));
                info.callbacks[isPicked ? 0 : 1]();
            });
        } else {
            // missed
            _pGlob.objClickInfo.forEach(info => info.callbacks[1]());
        }
    }
        
    function unbindListener(target, type, listener, optionsOrUseCapture) {
        const index = _pGlob.eventListeners.findIndex(elem => {
            return areListenersSame(elem.target, elem.type, elem.listener,
                elem.optionsOrUseCapture, target, type, listener,
                optionsOrUseCapture);
        });
    
        if (index !== -1) {
            target.removeEventListener(type, listener, optionsOrUseCapture);
            _pGlob.eventListeners.splice(index, 1);
        }
    }

    return {
        getElement, getElements, transformCoordsSpace, transformEulerV3dToBlenderShortest,
        getSceneCoordSystem, getObjectByName, retrieveObjectNames, RotationInterface,
        getObjectName, initObjectPicking, isObjectAmongObjects, bindListener,
        getMaterialEditableTextures, replaceMaterialEditableTexture, getMaterialEditableValues, CanvasTxt,
        MediaHTML5, getObjectUUID, xrGetIntersections, xrOnSelect,
        unbindListener,
    };
};

var PL = {};



// backward compatibility
if (v3d[Symbol.toStringTag] !== 'Module') {
    v3d.PL = v3d.puzzles = PL;
}

PL.procedures = PL.procedures || {};




PL.execInitPuzzles = function(options) {
    // always null, should not be available in "init" puzzles
    var appInstance = null;
    // app is more conventional than appInstance (used in exec script and app templates)
    var app = null;

    const PzLib = createPzLib({ v3d });

    // provide the container's id to puzzles that need access to the container
    _initGlob.container = options !== undefined && 'container' in options
            ? options.container : "";

    

    // addHTMLElement puzzle
function addHTMLElement(elemType, id, mode, targetId, isParent) {
    const win = isParent ? window.parent : window;

    const elem = win.document.createElement(elemType);
    if (id !== '')
        elem.id = id;

    const targetElem = PzLib.getElement(targetId, isParent);
    if (targetElem instanceof win.Element) {
        switch (mode) {
            case 'TO':
                targetElem.appendChild(elem);
                break;
            case 'BEFORE':
                targetElem.insertAdjacentElement('beforebegin', elem);
                break;
            case 'AFTER':
                targetElem.insertAdjacentElement('afterend', elem);
                break;
        }

        _pGlob.htmlElements.add(elem);
    } else
        console.error('add HTML element puzzle: Invalid element "' + targetId + '"');
}

// setHTMLElemAttribute puzzle
function setHTMLElemAttribute(attr, value, ids, isParent) {
    var elems = PzLib.getElements(ids, isParent);
    for (var i = 0; i < elems.length; i++) {
        var elem = elems[i];
        if (!elem) continue;

        if ((attr == 'href' || attr == 'src') && value instanceof Promise) {
            // resolve promise value for url-based attributes
            value.then(function(response) {
                elem[attr] = response;
            });
        } else {
            elem[attr] = value;
        }
    }
}

// setHTMLElemStyle puzzle
function setHTMLElemStyle(prop, value, ids, isParent) {
    var elems = PzLib.getElements(ids, isParent);
    for (var i = 0; i < elems.length; i++) {
        var elem = elems[i];
        if (!elem || !elem.style)
            continue;
        elem.style[prop] = value;
    }
}



// initSettings puzzle
_initGlob.output.initOptions.fadeAnnotations = true;
_initGlob.output.initOptions.useBkgTransp = false;
_initGlob.output.initOptions.preserveDrawBuf = false;
_initGlob.output.initOptions.useCompAssets = false;
_initGlob.output.initOptions.useFullscreen = false;


// initPreloader puzzle
_initGlob.output.initOptions.useCustomPreloader = true;
_initGlob.output.initOptions.preloaderStartCb = function() {
    _initGlob.percentage = 0;
    (function() {
    addHTMLElement('div', 'preloader_background', 'TO', ['CONTAINER'], false);
    setHTMLElemAttribute('style', "position: absolute; background-color: white; width: 100%; height: 100%; z-index: 10;", 'preloader_background', false);
    addHTMLElement('div', 'preloader_container', 'TO', 'preloader_background', false);
    setHTMLElemAttribute('style', "position: absolute; background-image: url(\'./DigiTal-Zwilling_Icon.png\'); width: 300px; height: 300px; z-index: 10; left: 50%; margin-left: -150px; top: 50%; margin-top: -150px; background-size: contain;", 'preloader_container', false);
})();
};
_initGlob.output.initOptions.preloaderProgressCb = function(percentage) {
    _initGlob.percentage = percentage;
    (function() {
    setHTMLElemStyle('transform', ['rotate(',Math.round(_initGlob.percentage) * 7.2,'deg)'].join(''), 'preloader_container', false);
})();
};
_initGlob.output.initOptions.preloaderEndCb = function() {
    _initGlob.percentage = 100;
    (function() {
    setHTMLElemStyle('display', 'none', 'preloader_background', false);
    setHTMLElemStyle('display', 'none', 'preloader_container', false);
})();
};

    return _initGlob.output;
}

PL.init = function(appInstance, initOptions) {

// app is more conventional than appInstance (used in exec script and app templates)
var app = appInstance;

const PzLib = createPzLib({ v3d, appInstance });

initOptions = initOptions || {};

if ('fadeAnnotations' in initOptions) {
    _pGlob.fadeAnnotations = initOptions.fadeAnnotations;
}

this.procedures["OpacityZero"] = OpacityZero;
this.procedures["VR_INIT"] = VR_INIT;

var TagAN, VR_mode, move_forward, move_side, dir_vector_forward, dir_vector_side, dir_vector, move_speed, ray_cast_position, raycast_result;

// setObjTransform puzzle
function setObjTransform(objSelector, isWorldSpace, mode, vector, offset) {
    const x = vector[0];
    const y = vector[1];
    const z = vector[2];

    if (isNaN(x) || isNaN(y) || isNaN(z)) {
        console.error('set transform puzzle: Invalid transform');
        return;
    }

    const objNames = PzLib.retrieveObjectNames(objSelector);

    function setObjProp(obj, prop, val) {
        if (!offset) {
            obj[mode][prop] = val;
        } else {
            if (mode != "scale")
                obj[mode][prop] += val;
            else
                obj[mode][prop] *= val;
        }
    }

    const inputsUsed = _pGlob.vec3Tmp.set(Number(x !== ''), Number(y !== ''), Number(z !== ''));
    const coords = _pGlob.vec3Tmp2.set(x || 0, y || 0, z || 0);

    if (mode === 'rotation') {
        // rotations are specified in degrees
        coords.multiplyScalar(v3d.MathUtils.DEG2RAD);
    }

    const coordSystem = PzLib.getSceneCoordSystem();

    PzLib.transformCoordsSpace(inputsUsed, coordSystem, 'Y_UP_RIGHT', true);
    PzLib.transformCoordsSpace(coords, coordSystem, 'Y_UP_RIGHT', mode === 'scale');

    for (let i = 0; i < objNames.length; i++) {

        const objName = objNames[i];
        if (!objName) continue;

        const obj = PzLib.getObjectByName(objName);
        if (!obj) continue;

        if (isWorldSpace && obj.parent) {
            obj.matrixWorld.decomposeE(obj.position, obj.rotation, obj.scale);

            if (inputsUsed.x) setObjProp(obj, "x", coords.x);
            if (inputsUsed.y) setObjProp(obj, "y", coords.y);
            if (inputsUsed.z) setObjProp(obj, "z", coords.z);

            obj.matrixWorld.composeE(obj.position, obj.rotation, obj.scale);
            obj.matrix.multiplyMatrices(_pGlob.mat4Tmp.copy(obj.parent.matrixWorld).invert(), obj.matrixWorld);
            obj.matrix.decompose(obj.position, obj.quaternion, obj.scale);

        } else if (mode === 'rotation' && coordSystem == 'Z_UP_RIGHT') {
            // Blender/Max coordinates

            // need all the rotations for order conversions, especially if some
            // inputs are not specified
            const euler = PzLib.transformEulerV3dToBlenderShortest(obj.rotation,
                    _pGlob.eulerTmp);
            PzLib.transformCoordsSpace(euler, coordSystem, 'Y_UP_RIGHT');

            if (inputsUsed.x) euler.x = offset ? euler.x + coords.x : coords.x;
            if (inputsUsed.y) euler.y = offset ? euler.y + coords.y : coords.y;
            if (inputsUsed.z) euler.z = offset ? euler.z + coords.z : coords.z;

            /**
             * convert from Blender/Max default XYZ extrinsic order to v3d XYZ
             * intrinsic with reversion (XYZ -> ZYX) and axes swizzling (ZYX -> YZX)
             */
            euler.order = "YZX";
            euler.reorder(obj.rotation.order);
            obj.rotation.copy(euler);

        } else if (mode === 'rotation' && coordSystem == 'Y_UP_RIGHT') {
            // Maya coordinates

            // Use separate rotation interface to fix ambiguous rotations for Maya,
            // might as well do the same for Blender/Max.

            const rotUI = PzLib.RotationInterface.initObject(obj);
            const euler = rotUI.getUserRotation(_pGlob.eulerTmp);
            // TODO(ivan): this probably needs some reasonable wrapping
            if (inputsUsed.x) euler.x = offset ? euler.x + coords.x : coords.x;
            if (inputsUsed.y) euler.y = offset ? euler.y + coords.y : coords.y;
            if (inputsUsed.z) euler.z = offset ? euler.z + coords.z : coords.z;

            rotUI.setUserRotation(euler);
            rotUI.getActualRotation(obj.rotation);
        } else {
            if (inputsUsed.x) setObjProp(obj, "x", coords.x);
            if (inputsUsed.y) setObjProp(obj, "y", coords.y);
            if (inputsUsed.z) setObjProp(obj, "z", coords.z);
        }

        obj.updateWorldMatrix(false, true);
    }

}

// setHTMLElemStyle puzzle
function setHTMLElemStyle(prop, value, ids, isParent) {
    var elems = PzLib.getElements(ids, isParent);
    for (var i = 0; i < elems.length; i++) {
        var elem = elems[i];
        if (!elem || !elem.style)
            continue;
        elem.style[prop] = value;
    }
}

// whenHovered puzzle
PzLib.initObjectPicking(function(intersects, event) {

    const prevHovered = _pGlob.hoveredObject;
    let currHovered = '';

    // the event might happen before hover registration
    _pGlob.objHoverInfo = _pGlob.objHoverInfo || [];

    // search for closest hovered object

    let lastIntersectIndex = Infinity;
    _pGlob.objHoverInfo.forEach(function(el) {
        const maxIntersects = el.xRay ? intersects.length : Math.min(1, intersects.length);

        for (let i = 0; i < maxIntersects; i++) {
            const obj = intersects[i].object;
            const objName = PzLib.getObjectName(obj);

            if (PzLib.isObjectAmongObjects(objName, PzLib.retrieveObjectNames(el.objSelector)) && i <= lastIntersectIndex) {
                currHovered = objName;
                lastIntersectIndex = i;
            }
        }
    });

    if (prevHovered == currHovered) return;

    // first - all "out" callbacks, then - all "over"
    _pGlob.objHoverInfo.forEach(function(el) {
        if (PzLib.isObjectAmongObjects(prevHovered, PzLib.retrieveObjectNames(el.objSelector))) {
            // ensure the correct value of the hoveredObject block
            _pGlob.hoveredObject = prevHovered;
            el.callbacks[1](event);
        }
    });

    _pGlob.objHoverInfo.forEach(function(el) {
        if (PzLib.isObjectAmongObjects(currHovered, PzLib.retrieveObjectNames(el.objSelector))) {
            // ensure the correct value of the hoveredObject block
            _pGlob.hoveredObject = currHovered;
            el.callbacks[0](event);
        }
    });

    _pGlob.hoveredObject = currHovered;
}, 'mousemove');

// whenHovered puzzle
function registerOnHover(objSelector, xRay, cbOver, cbOut) {

    _pGlob.objHoverInfo = _pGlob.objHoverInfo || [];

    _pGlob.objHoverInfo.push({
        objSelector: objSelector,
        callbacks: [cbOver, cbOut],
        xRay: xRay
    });
}

// show and hide puzzles
function changeVis(objSelector, bool) {
    var objNames = PzLib.retrieveObjectNames(objSelector);

    for (var i = 0; i < objNames.length; i++) {
        var objName = objNames[i]
        if (!objName)
            continue;
        var obj = PzLib.getObjectByName(objName);
        if (!obj)
            continue;
        obj.visible = bool;
        obj.resolveMultiMaterial().forEach(function(objR) {
            objR.visible = bool;
        });
    }
}

// replaceTexture puzzle
function replaceTexture(matName, texName, texUrlOrElem, noSharing, doCb) {

    const textures = PzLib.getMaterialEditableTextures(matName, true).filter(function(elem) {
        return elem.name == texName;
    });

    if (!textures.length)
        return;

    const mats = v3d.SceneUtils.getMaterialsByName(appInstance, matName);

    if (texUrlOrElem instanceof Promise) {

        texUrlOrElem.then(function(response) {
           processImageUrl(response);
        }, function(error) {});

    } else if (typeof texUrlOrElem == 'string') {

        processImageUrl(texUrlOrElem);

    /**
     * NOTE: not checking for the PzLib.MediaHTML5 constructor, because otherwise this
     * puzzle would always provide the code that's not needed most of the time
     */
    } else if (texUrlOrElem instanceof Object && texUrlOrElem.source
            instanceof HTMLVideoElement) {

        processVideo(texUrlOrElem.source);

    } else if (texUrlOrElem instanceof HTMLCanvasElement) {

        processCanvas(texUrlOrElem);

    } else {

        return;

    }

    function processImageUrl(url) {

        const isHDR = (url.search(/\.hdr$/) > 0);
        const isComp = (url.search(/\.ktx2/) > 0);

        let isCompOld = false;
        let isVideoOld = false;
        textures.forEach(function(elem) {
            if (elem.isCompressedTexture)
                isCompOld = true;
            if (elem.isVideoTexture)
                isVideoOld = true;
        });

        let loader;

        if (!isHDR && !isComp && !isCompOld && !isVideoOld) {
            loader = new v3d.ImageLoader();
            loader.setCrossOrigin('Anonymous');
        } else if (isComp) {
            loader = appInstance.loader.ktx2Loader;
            loader.setCrossOrigin('Anonymous');
        } else if (isCompOld || isVideoOld) {
            loader = new v3d.TextureLoader();
            loader.setCrossOrigin('Anonymous');
        } else {
            loader = new v3d.FileLoader();
            loader.setResponseType('arraybuffer');
        }

        loader.load(url, function(loadedData) {

            textures.forEach(function(oldTex) {
                oldTex.dispose();

                let newTex;

                if (!isHDR && !isComp && !isCompOld && !isVideoOld) {

                    if (noSharing) {
                        newTex = oldTex.clone();
                        mats.forEach(function(mat) {
                            PzLib.replaceMaterialEditableTexture(mat, oldTex, newTex);
                            mat.needsUpdate = true;
                        });
                    } else {
                        newTex = oldTex;
                    }

                    newTex.source = new v3d.Source(loadedData);

                } else if (isComp || isCompOld || isVideoOld) {

                    newTex = loadedData;

                    mats.forEach(function(mat) {
                        newTex.flipY = false;
                        newTex.name = texName;
                        PzLib.replaceMaterialEditableTexture(mat, oldTex, newTex);
                        mat.needsUpdate = true;
                        // HACK: to return back encoding in nodes, workaround for https://crbug.com/1256340
                        if (mat.isMeshNodeMaterial)
                            mat.updateNodeGraph(true);
                    });

                } else {
                    // parse loaded HDR buffer
                    const rgbeLoader = new v3d.RGBELoader();
                    const texData = rgbeLoader.parse(loadedData);

                    if (noSharing) {
                        newTex = oldTex.clone();
                        mats.forEach(function(mat) {
                            PzLib.replaceMaterialEditableTexture(mat, oldTex, newTex);
                            mat.needsUpdate = true;
                        });
                    } else {
                        newTex = oldTex;
                    }

                    newTex.source = new v3d.Source({
                        data: texData.data,
                        width: texData.width,
                        height: texData.height
                    });

                    newTex.magFilter = v3d.LinearFilter;
                    newTex.minFilter = v3d.LinearFilter;
                    newTex.generateMipmaps = false;
                    newTex.isDataTexture = true;
                }

                // update world material if it is using this texture
                if (appInstance.scene !== null && appInstance.scene.worldMaterial !== null) {
                    var wMat = appInstance.scene.worldMaterial;
                    for (let texName in wMat.nodeTextures) {
                        if (wMat.nodeTextures[texName] == newTex) {
                            appInstance.updateEnvironment(wMat);
                        }
                    }
                }
            });

            // exec once
            doCb();

        });
    }

    function processVideo(elem) {
        const videoTex = new v3d.VideoTexture(elem);
        videoTex.flipY = false;
        videoTex.name = texName;

        let videoAssigned = false;

        var mats = v3d.SceneUtils.getMaterialsByName(appInstance, matName);
        mats.forEach(function(mat) {

            textures.forEach(function(tex) {
                PzLib.replaceMaterialEditableTexture(mat, tex, videoTex);
            });

            mat.needsUpdate = true;
            // HACK: to assign new encoding in nodes, workaround for https://crbug.com/1256340
            if (mat.isMeshNodeMaterial) {
                if (v3d.engineVersionCmp('4.9.0', v3d.REVISION) >= 0) {
                    mat.updateNodeGraph(true);
                } else {
                    // COMPAT: <4.9.0, new puzzles, old engine
                    // HACK: preserve links to uniform arrays which got replaced in updateNodeGraph()
                    const nodeRGBArrSave = mat.nodeRGBArr;
                    const nodeValueSave = mat.nodeValue;
                    mat.updateNodeGraph();
                    mat.nodeRGBArr = nodeRGBArrSave;
                    mat.nodeValue = nodeValueSave;
                }
            }

            videoAssigned = true;
        });

        if (videoAssigned) {
            if (elem.readyState < 1) {
                PzLib.bindListener(elem, 'loadedmetadata', doCb);
            } else {
                doCb();
            }
        }

    }

    function processCanvas(elem) {
        const canvasTex = new v3d.CanvasTexture(elem);
        canvasTex.flipY = false;
        canvasTex.name = texName;

        let canvasAssigned = false;

        var mats = v3d.SceneUtils.getMaterialsByName(appInstance, matName);
        mats.forEach(function(mat) {

            textures.forEach(function(tex) {
                PzLib.replaceMaterialEditableTexture(mat, tex, canvasTex);
            });

            mat.needsUpdate = true;
            canvasAssigned = true;
        });

        if (canvasAssigned) {

            if (PL) {
                PL.canvasTextures = PL.canvasTextures || {};
                PL.canvasTextures[canvasTex.image.id] = canvasTex;
            }

            doCb();
        }

    }
}

// setMaterialValue puzzle
function setMaterialValue(matName, valName, value) {

    var values = PzLib.getMaterialEditableValues(matName);
    if (values.indexOf(valName) < 0)
        return;

    var mats = v3d.SceneUtils.getMaterialsByName(appInstance, matName);

    for (var i = 0; i < mats.length; i++) {
        var mat = mats[i];

        if (mat.isMeshNodeMaterial) {
            var valIdx = mat.nodeValueMap[valName];
            mat.nodeValue[valIdx] = Number(value);
        } else
            mat[valName] = Number(value);

        if (appInstance.scene !== null) {
            if (mat === appInstance.scene.worldMaterial) {
                appInstance.updateEnvironment(mat);
            }
        }
    }
}

// Describe this function...
function OpacityZero() {
    setMaterialValue('Text-Brueck', 'Opacity', 0);
    setMaterialValue('Text-Digi', 'Opacity', 0);
    setMaterialValue('Text-TagNacht', 'Opacity', 0);
    setMaterialValue('Text_Garten', 'Opacity', 0);
    setMaterialValue('Text_Park', 'Opacity', 0);
    setMaterialValue('Text_Strasse', 'Opacity', 0);
}

// textureFromTextAdv puzzle
function textureFromTextAdv(text, width, height, family, size, horizontalAlign, verticalAlign, lineHeight, justify, boxX, boxY, boxWidth, boxHeight, textColor, bgColor) {
    const CanvasTxt = PzLib.CanvasTxt;
    const canvas = document.createElement('canvas');
    canvas.width = width;
    canvas.height = height;

    const ctx = canvas.getContext('2d');
    // clear color first to prevent severe pixelating
    ctx.fillStyle = bgColor;
    ctx.fillRect(0, 0, canvas.width, canvas.height);
    ctx.fillStyle = textColor;

    CanvasTxt.font = family;
    CanvasTxt.fontSize = size;
    CanvasTxt.align = horizontalAlign;
    CanvasTxt.vAlign = verticalAlign;
    CanvasTxt.lineHeight = lineHeight;
    CanvasTxt.justify = justify;
    CanvasTxt.debug = false;

    boxWidth = Math.max(size, boxWidth); // to avoid infinity loop in CanvasTxt

    CanvasTxt.drawText(ctx, text, boxX, boxY, boxWidth, boxHeight);

    return canvas.toDataURL();
}

// createVector puzzle
function createVector(x, y, z) {
    return [x, y, z];
};

// getObjectMaterial puzzle
function getObjectMaterial(objSelector, matIndex, useID) {
    const objNames = PzLib.retrieveObjectNames(objSelector);

    for (let i = 0; i < objNames.length; i++) {
        const objName = objNames[i]
        if (!objName)
            continue;
        let obj = PzLib.getObjectByName(objName);
        if (!obj)
            continue;

        const objsM = obj.resolveMultiMaterial();

        if (Number.isInteger(matIndex)) {
            if (matIndex >= 1 && matIndex <= objsM.length) {
                obj = objsM[matIndex-1];
            } else {
                console.error('get object material puzzle: invalid material index ' + matIndex);
                continue;
            }
        } else {
            obj = objsM[0];
        }

        if (obj.material) {
            // COMPAT: <4.9.0, old engine, new puzzles, see getMaterialByName()
            if (useID && v3d.MathUtils.checkUUID)
                return obj.material.uuid;
            else
                return obj.material.name;
        } else {
            console.error('get object material puzzle: invalid object ' + obj.name);
        }
    }
    return '';
}

// loadVideo puzzle
function loadVideo(url) {
    var elems = _pGlob.mediaElements;
    if (!(url in elems)) {
        elems[url] = new PzLib.MediaHTML5().load(url, true);
    }
    return elems[url];
}

// stopSound puzzle
function stopSound(mediaElem) {
    const mediaElems = (Array.isArray(mediaElem) ? mediaElem : [mediaElem]).filter(elem => elem);
    mediaElems.forEach(mediaElem => {
        mediaElem.stop();
    });
}

// playSound puzzle
function playSound(mediaElem, loop) {
    const mediaElems = (Array.isArray(mediaElem) ? mediaElem : [mediaElem]).filter(elem => elem);
    mediaElems.forEach(mediaElem => {
        mediaElem.setLoop(loop);
        if (mediaElem.audio)
            mediaElem.audio.context.resume();
        mediaElem.play();
    });
}

// whenClicked puzzle
function registerOnClick(objSelector, xRay, doubleClick, mouseButtons, useID, cbDo, cbIfMissedDo) {

    // for AR/VR
    _pGlob.objClickInfo = _pGlob.objClickInfo || [];

    _pGlob.objClickInfo.push({
        objSelector: objSelector,
        useID: useID,
        callbacks: [cbDo, cbIfMissedDo]
    });

    PzLib.initObjectPicking(function(intersects, event) {

        let isPicked = false;

        const maxIntersects = xRay ? intersects.length : Math.min(1, intersects.length);

        for (let i = 0; i < maxIntersects; i++) {
            const obj = intersects[i].object;

            const objName = PzLib.getObjectName(obj);
            const objUUID = PzLib.getObjectUUID(obj);
            const objNames = PzLib.retrieveObjectNames(objSelector);

            if (PzLib.isObjectAmongObjects(objName, objUUID, objNames)) {
                // save the object for the pickedObject block
                _pGlob.pickedObject = useID ? objUUID : objName;
                isPicked = true;
                cbDo(event);
            }
        }

        if (!isPicked) {
            _pGlob.pickedObject = '';
            cbIfMissedDo(event);
        }

    }, doubleClick ? 'dblclick' : 'mousedown', false, mouseButtons);
}

// addHTMLElement puzzle
function addHTMLElement(elemType, id, mode, targetId, isParent) {
    const win = isParent ? window.parent : window;

    const elem = win.document.createElement(elemType);
    if (id !== '')
        elem.id = id;

    const targetElem = PzLib.getElement(targetId, isParent);
    if (targetElem instanceof win.Element) {
        switch (mode) {
            case 'TO':
                targetElem.appendChild(elem);
                break;
            case 'BEFORE':
                targetElem.insertAdjacentElement('beforebegin', elem);
                break;
            case 'AFTER':
                targetElem.insertAdjacentElement('afterend', elem);
                break;
        }

        _pGlob.htmlElements.add(elem);
    } else
        console.error('add HTML element puzzle: Invalid element "' + targetId + '"');
}

// setHTMLElemAttribute puzzle
function setHTMLElemAttribute(attr, value, ids, isParent) {
    var elems = PzLib.getElements(ids, isParent);
    for (var i = 0; i < elems.length; i++) {
        var elem = elems[i];
        if (!elem) continue;

        if ((attr == 'href' || attr == 'src') && value instanceof Promise) {
            // resolve promise value for url-based attributes
            value.then(function(response) {
                elem[attr] = response;
            });
        } else {
            elem[attr] = value;
        }
    }
}

// getHTMLElemAttribute puzzle
function getHTMLElemAttribute(attr, id, isParent) {
    var elem = PzLib.getElement(id, isParent);
    return elem ? elem[attr]: '';
}

// setInterval puzzle
function registerInterval(timeout, callback) {
    var timerId = window.setInterval(function() { callback(timerId) }, 1000 * timeout);
}

// createCSSRule puzzle
function createCSSRule(cssRule, cssRuleCont, isParent, mediaRule) {
    var style = document.createElement('style');
    style.type = 'text/css';
    if (mediaRule) {
        style.innerHTML = `@media ${mediaRule} { ${cssRule} { ${cssRuleCont} } }`;
    } else {
        style.innerHTML = `${cssRule} { ${cssRuleCont} }`;
    }

    var styles = (isParent) ? parent.document.getElementsByTagName('head')[0] :
                              document.getElementsByTagName('head')[0];
    styles.appendChild(style)
}

// checkVRMode puzzle
function checkVRMode(availableCb, unAvailableCb) {
    v3d.Detector.checkWebXR('immersive-vr', availableCb, unAvailableCb);
}

// eventHTMLElem puzzle
function eventHTMLElem(eventType, ids, isParent, callback) {
    var elems = PzLib.getElements(ids, isParent);
    for (var i = 0; i < elems.length; i++) {
        var elem = elems[i];
        if (!elem)
            continue;

        PzLib.bindListener(elem, eventType, callback);
    }
}

// enterVRMode puzzle
function enterVRMode(refSpace, enterCb, exitCb, unAvailableCb) {

    var DEFAULT_DEPTH = 10;

    var _rayReticleDepth = [];
    var _hoveredObjects = [];

    function onControllerHover() {

        var controllers = appInstance.xrControllers;

        for (var i = 0; i < controllers.length; i++) {
            var controller = controllers[i];

            var intersections = PzLib.xrGetIntersections(controller);

            if (intersections.length > 0) {
                var intersection = intersections[0];
                var obj = intersection.object;
                _rayReticleDepth[i] = intersection.distance;
            } else {
                var obj = null;
                _rayReticleDepth[i] = DEFAULT_DEPTH;
            }

            controller.children.forEach(function(child) {
                if (child.name.indexOf('_RAY') > -1) {
                    child.scale.z = _rayReticleDepth[i];
                } else if (child.name.indexOf('_RETICLE') > -1) {
                    // reduces crossing artefacts
                    child.position.z = -0.95 * _rayReticleDepth[i];
                }
            });

            var prevHovered = _hoveredObjects[i];
            var currHovered = obj ? PzLib.getObjectName(obj) : '';

            if (prevHovered == currHovered) {
                continue;
            }

            // first - all "out" callbacks, then - all "over"
            _pGlob.objHoverInfo.forEach(function(el) {
                if (PzLib.isObjectAmongObjects(prevHovered, PzLib.retrieveObjectNames(el.objSelector))) {
                    // ensure the correct value of the hoveredObject block
                    _pGlob.hoveredObject = prevHovered;
                    el.callbacks[1]();
                }
            });

            _pGlob.objHoverInfo.forEach(function(el) {
                if (PzLib.isObjectAmongObjects(currHovered, PzLib.retrieveObjectNames(el.objSelector))) {
                    // ensure the correct value of the hoveredObject block
                    _pGlob.hoveredObject = currHovered;
                    el.callbacks[0]();
                }
            });

            _hoveredObjects[i] = currHovered;
        }
    }

    switch (refSpace) {
        case 'SITTING':
            var referenceSpace = 'local-floor';
            break;
        case 'WALKING':
            var referenceSpace = 'unbounded';
            break;
        case 'ORIGIN':
            var referenceSpace = 'local';
            break;
        case 'ROOM':
            var referenceSpace = 'bounded-floor';
            break;
        case 'VIEWER':
            var referenceSpace = 'viewer';
            break;
        default:
            console.error('enter VR mode puzzle: Wrong VR reference space');
            return;
    }

    appInstance.initWebXR('immersive-vr', referenceSpace, function() {

        var controllers = appInstance.xrControllers;

        for (var i = 0; i < controllers.length; i++) {
            var controller = controllers[i];

            // clicks
            PzLib.bindListener(controller, 'select', PzLib.xrOnSelect);

            _pGlob.xrSessionCallbacks.forEach(function(pair) {
                PzLib.bindListener(controller, pair[0], pair[1]);
            });
        }

        // hovers
        if (_pGlob.objHoverInfo && _pGlob.objHoverInfo.length && appInstance.renderCallbacks.indexOf(onControllerHover) == -1)
            appInstance.renderCallbacks.push(onControllerHover);

        _pGlob.xrSessionAcquired = true;

        enterCb();

    }, unAvailableCb, function() {

        var controllers = appInstance.xrControllers;

        for (var i = 0; i < controllers.length; i++) {
            var controller = controllers[i];

            PzLib.unbindListener(controller, 'select', PzLib.xrOnSelect);

            _pGlob.xrSessionCallbacks.forEach(function(pair) {
                PzLib.unbindListener(controller, pair[0], pair[1]);
            });
        }

        var cbIdx = appInstance.renderCallbacks.indexOf(onControllerHover);
        if (cbIdx != -1)
            appInstance.renderCallbacks.splice(cbIdx, 1);

        _pGlob.xrSessionAcquired = false;

        // to cleanup XR_CAMERA_CONTROL_OBJECT and XR controllers
        _pGlob.objCache.clear();

        exitCb();
    });
}

// Describe this function...
function VR_INIT() {
    enterVRMode('ORIGIN', function() {
        VR_mode = true;
    }, function() {
        VR_mode = false;
    }, function() {});
}


TagAN = true;
setObjTransform('panorama_camera', false, 'rotation', [0, 0, 107], false);
registerOnHover([['GROUP', 'Bruecke-56'], ['GROUP', 'garten-90'], ['GROUP', 'Strasse-90'], ['GROUP', 'Park+107']], false, function(event) {
    setHTMLElemStyle('cursor', 'pointer', ['BODY'], false);
}, function(event) {
    setHTMLElemStyle('cursor', 'default', ['BODY'], false);
});
changeVis([['GROUP', 'Bruecke-56'], ['GROUP', 'garten-90'], ['GROUP', 'Strasse-90']], false);
replaceTexture('panorama_room', 'Parkbild.webp', 'Parkbild.webp', false, function() {
    setObjTransform('panorama_camera', false, 'rotation', [0, 0, 107], false);
    changeVis(['GROUP', 'Park+107'], true);
});
OpacityZero();

replaceTexture('Text-Brueck', 'GT1.png', textureFromTextAdv('Brücke Luftansicht', 1646, 128, 'Arial', 100, 'center', 'middle', 0, false, 0, -14, 1646, 128, '#ffffff', '#000000'), false, function() {});
replaceTexture('Text_Park', 'GT2.png', textureFromTextAdv('Zugang Kaiserhöhe', 1646, 128, 'Arial', 100, 'center', 'middle', 0, false, 0, -14, 1646, 128, '#ffffff', '#000000'), false, function() {});
replaceTexture('Text_Strasse', 'GT3.png', textureFromTextAdv('Talsohle Friedrich-Ebert-Str.', 1646, 128, 'Arial', 100, 'center', 'middle', 0, false, 0, -14, 1646, 128, '#ffffff', '#000000'), false, function() {});
replaceTexture('Text_Garten', 'GT4.png', textureFromTextAdv('Kleingartenanlage Nützenberg', 1646, 128, 'Arial', 100, 'center', 'middle', 0, false, 0, -14, 1646, 128, '#ffffff', '#000000'), false, function() {});
replaceTexture('Text-TagNacht', 'tag.png', textureFromTextAdv('Tag / Nacht', 1646, 128, 'Arial', 100, 'center', 'middle', 0, false, 0, -14, 1646, 128, '#ffffff', '#000000'), false, function() {});

setObjTransform('DigiZwilling', false, 'rotation', createVector(0, 0, 0), false);

registerOnHover([['GROUP', 'Park+107'], ['GROUP', 'garten-90'], ['GROUP', 'Bruecke-56'], ['GROUP', 'Strasse-90']], true, function(event) {
    setMaterialValue(getObjectMaterial(_pGlob.hoveredObject, 2, false), 'Opacity', 1);
}, function(event) {
    setMaterialValue(getObjectMaterial(_pGlob.hoveredObject, 2, false), 'Opacity', 0);
});

registerOnHover('DigiZwilling', true, function(event) {
    setMaterialValue('Text-Digi', 'Opacity', 1);
}, function(event) {
    setMaterialValue('Text-Digi', 'Opacity', 0);
});

registerOnClick('Icon-Bruecke-TagNacht', false, false, [0,1,2], false, function(event) {
    if (TagAN) {
            stopSound(loadVideo('videos/Tag.mp4'));
            replaceTexture('panorama_room', 'Parkbild.webp', loadVideo('videos/Nacht.mp4'), false, function() {
                playSound(loadVideo('videos/Nacht.mp4'), true);
            });
            TagAN = false;
    } else {
            stopSound(loadVideo('videos/Nacht.mp4'));
            replaceTexture('panorama_room', 'Parkbild.webp', loadVideo('videos/Tag.mp4'), false, function() {
                playSound(loadVideo('videos/Tag.mp4'), true);
            });
            TagAN = true;
    }
}, function(event) {});

registerOnClick(['Icon-Park', 'Icon-Strasse.001', 'Icon-Garten.001'], false, false, [0,1,2], false, function(event) {
    OpacityZero();
    replaceTexture('panorama_room', 'Parkbild.webp', loadVideo('videos/Tag.mp4'), false, function() {
        stopSound(loadVideo('videos/Nacht.mp4'));
        playSound(loadVideo('videos/Tag.mp4'), true);
        setObjTransform('panorama_camera', false, 'rotation', [0, 0, 160], false);
        changeVis([['GROUP', 'Bruecke-56'], ['GROUP', 'garten-90'], ['GROUP', 'Strasse-90'], ['GROUP', 'Park+107']], false);
        changeVis(['GROUP', 'Bruecke-56'], true);
        setObjTransform('DigiZwilling', false, 'rotation', createVector(0, 0, -15), false);
    });
}, function(event) {});

registerOnClick(['Icon-Bruecke', 'Icon-Strasse.002', 'Icon-Garten.002'], false, false, [0,1,2], false, function(event) {
    OpacityZero();
    stopSound(loadVideo('videos/Tag.mp4'));
    stopSound(loadVideo('videos/Nacht.mp4'));
    replaceTexture('panorama_room', 'Parkbild.webp', 'Parkbild.webp', false, function() {
        setObjTransform('panorama_camera', false, 'rotation', [0, 0, 107], false);
        changeVis([['GROUP', 'Bruecke-56'], ['GROUP', 'garten-90'], ['GROUP', 'Strasse-90'], ['GROUP', 'Park+107']], false);
        changeVis(['GROUP', 'Park+107'], true);
        setObjTransform('DigiZwilling', false, 'rotation', createVector(0, 0, 0), false);
    });
}, function(event) {});

registerOnClick(['Icon-Park.001', 'Icon-Strasse', 'Icon-Bruecke.001'], false, false, [0,1,2], false, function(event) {
    OpacityZero();
    stopSound(loadVideo('videos/Tag.mp4'));
    stopSound(loadVideo('videos/Nacht.mp4'));
    replaceTexture('panorama_room', 'Parkbild.webp', 'Gaerten.webp', false, function() {
        setObjTransform('panorama_camera', false, 'rotation', [0, 0, -90], false);
        changeVis([['GROUP', 'Bruecke-56'], ['GROUP', 'garten-90'], ['GROUP', 'Strasse-90'], ['GROUP', 'Park+107']], false);
        changeVis(['GROUP', 'garten-90'], true);
        setObjTransform('DigiZwilling', false, 'rotation', createVector(0, 0, -154), false);
    });
}, function(event) {});

registerOnClick(['Icon-Garten', 'Icon-Bruecke.002', null], false, false, [0,1,2], false, function(event) {
    OpacityZero();
    stopSound(loadVideo('videos/Tag.mp4'));
    stopSound(loadVideo('videos/Nacht.mp4'));
    replaceTexture('panorama_room', 'Parkbild.webp', '360-Strasse.webp', false, function() {
        setObjTransform('panorama_camera', false, 'rotation', [0, 0, -90], false);
        changeVis([['GROUP', 'Bruecke-56'], ['GROUP', 'garten-90'], ['GROUP', 'Strasse-90'], ['GROUP', 'Park+107']], false);
        changeVis(['GROUP', 'Strasse-90'], true);
        setObjTransform('DigiZwilling', false, 'rotation', createVector(0, 0, -160), false);
    });
}, function(event) {});

    addHTMLElement('div', 'rotate_your_phone', 'TO', ['CONTAINER'], false);
    setHTMLElemAttribute('style', "position: absolute; background-image: url(\'media/rotate_your_phone.svg\'); background-size: 100%; width: 300px; height: 200px; left: 50%; margin-left: -150px; top: 50%; margin-top: -100px; display: none;", 'rotate_your_phone', false);
    registerInterval(0.1, function() {
        if (getHTMLElemAttribute('innerWidth', ['WINDOW'], false) / getHTMLElemAttribute('innerHeight', ['WINDOW'], false) > 1) {
            setHTMLElemStyle('display', 'none', 'rotate_your_phone', false);
        } else {
            setHTMLElemStyle('display', 'block', 'rotate_your_phone', false);
        }
    });

('position:absolute;' + '\n' +
'display:none;' + '\n' +
'width:200px;' + '\n' +
'height:40px;' + '\n' +
'text-align:center;' + '\n' +
'bottom:150px;' + '\n' +
'right:50%;' + '\n' +
'margin-right:-100px;' + '\n' +
'border-radius:20px;' + '\n' +
'color:white;' + '\n' +
'font-family: Verdana, sans-serif;' + '\n' +
'font-weight:bolt;' + '\n' +
'font-size: 20px;' + '\n' +
'line-height:2;' + '\n' +
'border:1px solid white;' + '\n' +
'cursor:pointer;' + '\n' +
'background-image:url(\'./img/vr-helm.svg\');' + '\n' +
'background-repeat: no-repeat;' + '\n' +
'background-size: 40px;' + '\n' +
'background-position: top 4px right 15px;' + '\n' +
'background-color:#00AEB2;');

    /* VR */
    VR_mode = false;
    /* INTERFACE */
    createCSSRule('.enter-vr-button', "position: absolute; display: none; width: 240px; height: 40px; text-align: center; bottom: 150px; right: 50%; margin-right: -100px; border-radius: 20px; color: white; font-family: Verdana, sans-serif; font-weight: bold; font-size: 20px; line-height: 2; border: 1px solid white; cursor: pointer; background-image: url(\'./img/vr-helm.svg\'); background-repeat: no-repeat; background-size: 40px; background-position: top 4px right 15px; background-color: #00AEB2;", false, '');
    addHTMLElement('div', 'enter_vr_button', 'TO', ['CONTAINER'], false);
    setHTMLElemAttribute('className', 'enter-vr-button', 'enter_vr_button', false);
    setHTMLElemAttribute('innerHTML', 'ENTER VR', 'enter_vr_button', false);
    checkVRMode(function() {
        setHTMLElemStyle('display', 'block', 'enter_vr_button', false);
    }, function() {
        setHTMLElemStyle('display', 'none', 'enter_vr_button', false);
    });
    eventHTMLElem('click', 'enter_vr_button', false, function(event) {
        VR_INIT();
    });



} // end of PL.init function

PL.disposeListeners = function() {
    if (_pGlob) {
        _pGlob.eventListeners.forEach(({ target, type, listener, optionsOrUseCapture }) => {
            target.removeEventListener(type, listener, optionsOrUseCapture);
        });
        _pGlob.eventListeners.length = 0;
    }
}

PL.disposeHTMLElements = function() {
    if (_pGlob) {
        _pGlob.htmlElements.forEach(elem => {
            elem.remove();
        });
        _pGlob.htmlElements.clear();
    }
}

PL.disposeMaterialsCache = function() {
    if (_pGlob) {
        for (const mat of _pGlob.materialsCache.values()) {
            mat.dispose();
        }
        _pGlob.materialsCache.clear();
    }
}

PL.dispose = function() {
    PL.disposeListeners();
    PL.disposeHTMLElements();
    PL.disposeMaterialsCache();
    _pGlob = null;
    // backward compatibility
    if (v3d[Symbol.toStringTag] !== 'Module') {
        delete v3d.PL;
        delete v3d.puzzles;
    }
}



return PL;

}

export { createPL };
